﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include "ApplicationStatus.h"
#include "Pad.h"

namespace nns { namespace ldn
{
    /**
     * @brief           シーンの更新インタフェースです。
     */
    struct IUpdater
    {
        /**
         * @brief           デストラクタです。
         */
        virtual ~IUpdater() NN_NOEXCEPT
        {
        }

        /**
         * @brief           シーンの開始時に一度だけ実行される処理です。
         * @param[in]       app             アプリケーションの状態です。
         */
        virtual void Setup(const ApplicationStatus& app) NN_NOEXCEPT = 0;

        /**
         * @brief           シーンの終了時に一度だけ実行される処理です。
         * @param[in]       app             アプリケーションの状態です。
         */
        virtual void Cleanup(const ApplicationStatus& app) NN_NOEXCEPT = 0;

        /**
         * @brief           シーン特有のデータを取得します。
         * @return          シーン特有のデータです。
         */
        virtual const void* GetSceneData() const NN_NOEXCEPT = 0;

        /**
         * @brief           次に実行すべきシーンを取得します。
         * @return          次に実行すべきシーンです。遷移不要な場合は Scene_None を返します。
         */
        virtual Scene GetNextScene() const NN_NOEXCEPT = 0;

        /**
         * @brief           シーンの更新処理です。
         * @param[in]       app             アプリケーションの状態です。
         * @param[in]       padStates       パッドの入力状態です。
         */
        virtual void Update(
            const ApplicationStatus& app,
            const PadState (&padStates)[PadCountMax]) NN_NOEXCEPT = 0;
    };

}} // namespace nns::ldn
