﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include "LdnData.h"
#include "Task.h"
#include "TaskRunner.h"
#include "Updater.h"

namespace nns { namespace ldn
{
    /**
     * @brief           ローカル通信中の更新処理です。
     */
    class LdnUpdater : public IUpdater
    {
        NN_DISALLOW_COPY(LdnUpdater);
        NN_DISALLOW_MOVE(LdnUpdater);

    public:

        /**
         * @brief           コンストラクタです。
         */
        LdnUpdater() NN_NOEXCEPT;

        /**
         * @brief           デストラクタです。
         */
        virtual ~LdnUpdater() NN_NOEXCEPT;

        virtual void Setup(const ApplicationStatus& app) NN_NOEXCEPT NN_OVERRIDE;

        virtual void Cleanup(const ApplicationStatus& app) NN_NOEXCEPT NN_OVERRIDE;

        virtual const void* GetSceneData() const NN_NOEXCEPT NN_OVERRIDE;

        virtual Scene GetNextScene() const NN_NOEXCEPT NN_OVERRIDE;

        virtual void Update(
            const ApplicationStatus& app,
            const PadState (&padStates)[PadCountMax]) NN_NOEXCEPT NN_OVERRIDE;

    private:

        static const int TaskCountMax = 4;

        void UpdateInitializing(
            const ApplicationStatus& app, const PadState &padState) NN_NOEXCEPT;

        void UpdateInitialized(
            const ApplicationStatus& app, const PadState &padState) NN_NOEXCEPT;

        void UpdateStation(
            const ApplicationStatus& app, const PadState &padState) NN_NOEXCEPT;

        void UpdateStationScanning(
            const ApplicationStatus& app, const PadState &padState) NN_NOEXCEPT;

        void UpdateStationConnecting(
            const ApplicationStatus& app, const PadState &padState) NN_NOEXCEPT;

        void UpdateStationConnected(
            const ApplicationStatus& app, const PadState &padState) NN_NOEXCEPT;

        void UpdateStationDisconnected(
            const ApplicationStatus& app, const PadState &padState) NN_NOEXCEPT;

        void UpdateStationClosing(
            const ApplicationStatus& app, const PadState &padState) NN_NOEXCEPT;

        void UpdateAccessPointCreating(
            const ApplicationStatus& app, const PadState &padState) NN_NOEXCEPT;

        void UpdateAccessPointCreated(
            const ApplicationStatus& app, const PadState &padState) NN_NOEXCEPT;

        void UpdateAccessPointScanning(
            const ApplicationStatus& app, const PadState &padState) NN_NOEXCEPT;

        void UpdateAccessPointClosing(
            const ApplicationStatus& app, const PadState &padState) NN_NOEXCEPT;

        void UpdateAccessPointRejecting(
            const ApplicationStatus& app, const PadState &padState) NN_NOEXCEPT;

        void UpdateFinalizing(
            const ApplicationStatus& app, const PadState &padState) NN_NOEXCEPT;

        void UpdateError(
            const ApplicationStatus& app, const PadState &padState) NN_NOEXCEPT;

        void SetNextScene(Scene scene) NN_NOEXCEPT;
        void SetNextSubScene(LdnSubScene scene) NN_NOEXCEPT;
        void StartCommunication(const Config& config) NN_NOEXCEPT;
        void StopCommunication() NN_NOEXCEPT;

        LdnData m_Data;
        Scene m_NextScene;
        LdnSubScene m_NextSubScene;
        SequentialTaskRunner<nn::Result, 4> m_Runner;
        SequentialVoidTaskRunner<4> m_Sender;
        SequentialVoidTaskRunner<4> m_Receiver;
        nn::os::SystemEventType m_StateChangeEvent;
        int m_Socket;
    };

}} // namespace nns::ldn
