﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include "LdnData.h"
#include "Drawer.h"

namespace nns { namespace ldn
{
    /**
     * @brief           ローカル通信中の描画処理です。
     */
    class LdnDrawer : public IDrawer
    {
        NN_DISALLOW_COPY(LdnDrawer);
        NN_DISALLOW_MOVE(LdnDrawer);

    public:

        /**
         * @brief           コンストラクタです。
         */
        LdnDrawer() NN_NOEXCEPT;

        /**
         * @brief           デストラクタです。
         */
        virtual ~LdnDrawer() NN_NOEXCEPT;

        virtual void Setup(const ApplicationStatus& app) NN_NOEXCEPT NN_OVERRIDE;

        virtual void Cleanup(const ApplicationStatus& app) NN_NOEXCEPT NN_OVERRIDE;

        virtual void Draw(const ApplicationStatus& app) NN_NOEXCEPT NN_OVERRIDE;

    private:

        void DrawInitializing(
            const ApplicationStatus& app, const LdnData& data) NN_NOEXCEPT;

        void DrawInitialized(
            const ApplicationStatus& app, const LdnData& data) NN_NOEXCEPT;

        void DrawStation(
            const ApplicationStatus& app, const LdnData& data) NN_NOEXCEPT;

        void DrawStationScanning(
            const ApplicationStatus& app, const LdnData& data) NN_NOEXCEPT;

        void DrawStationClosing(
            const ApplicationStatus& app, const LdnData& data) NN_NOEXCEPT;

        void DrawStationConnecting(
            const ApplicationStatus& app, const LdnData& data) NN_NOEXCEPT;

        void DrawStationConnected(
            const ApplicationStatus& app, const LdnData& data) NN_NOEXCEPT;

        void DrawStationDisconnected(
            const ApplicationStatus& app, const LdnData& data) NN_NOEXCEPT;

        void DrawAccessPointCreating(
            const ApplicationStatus& app, const LdnData& data) NN_NOEXCEPT;

        void DrawAccessPointCreated(
            const ApplicationStatus& app, const LdnData& data) NN_NOEXCEPT;

        void DrawAccessPointScanning(
            const ApplicationStatus& app, const LdnData& data) NN_NOEXCEPT;

        void DrawAccessPointRejecting(
            const ApplicationStatus& app, const LdnData& data) NN_NOEXCEPT;

        void DrawAccessPointClosing(
            const ApplicationStatus& app, const LdnData& data) NN_NOEXCEPT;

        void DrawFinalizing(
            const ApplicationStatus& app, const LdnData& data) NN_NOEXCEPT;

        void DrawError(
            const ApplicationStatus& app, const LdnData& data) NN_NOEXCEPT;
    };

}} // namespace nns::ldn
