﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include "ApplicationStatus.h"

namespace nns { namespace ldn
{
    /**
     * @brief           シーンの描画インタフェースです。
     */
    struct IDrawer
    {
        /**
         * @brief           デストラクタです。
         */
        virtual ~IDrawer() NN_NOEXCEPT
        {
        }

        /**
         * @brief           シーンの開始時に一度だけ実行される処理です。
         * @param[in]       app             アプリケーションの状態です。
         */
        virtual void Setup(const ApplicationStatus& app) NN_NOEXCEPT = 0;

        /**
         * @brief           シーンの終了時に一度だけ実行される処理です。
         * @param[in]       app             アプリケーションの状態です。
         */
        virtual void Cleanup(const ApplicationStatus& app) NN_NOEXCEPT = 0;

        /**
         * @brief           シーンの描画処理です。
         * @param[in]       app             アプリケーションの状態です。
         */
        virtual void Draw(const ApplicationStatus& app) NN_NOEXCEPT = 0;
    };

}} // namespace nns::ldn
