﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/hid/hid_NpadCommonTypes.h>

/*!
    @brief      ヒューマンインターフェイスデバイス機能が初期化済みかを判定します。
    @return     初期化済みならば true を返します。
*/
bool IsHidControllerInitialized() NN_NOEXCEPT;

/*!
    @brief      ヒューマンインターフェイスデバイス機能を初期化します。
*/
void InitializeHidController() NN_NOEXCEPT;

/*!
    @brief      ヒューマンインターフェイスデバイス機能を終了します。
*/
void FinalizeHidController() NN_NOEXCEPT;

/*!
    @brief      ヒューマンインターフェイスデバイス機能を終了します。
*/
void UpdateHidController() NN_NOEXCEPT;

/*!
    @brief      指定されたデジタルボタンの何れかが押下中か否かを返します。
    @param[in]      buttons         デジタルボタンの指定です。
    @return     指定されたデジタルボタンの何れかが押下中なら真を返します。
*/
bool HasHidControllerAnyButtons(nn::hid::NpadButtonSet buttons) NN_NOEXCEPT;

/*!
    @brief      指定されたデジタルボタンの何れかが最後の更新で新たに押下されたか否かを返します。
    @param[in]      buttons         デジタルボタンの指定です。
    @return     指定されたデジタルボタンの何れかが新たに押下されたなら真を返します。
*/
bool HasHidControllerAnyButtonsDown(nn::hid::NpadButtonSet buttons) NN_NOEXCEPT;

/*!
    @brief      指定されたデジタルボタンの何れかが最後の更新で新たに開放されたか否かを返します。
    @param[in]      buttons         デジタルボタンの指定です。
    @return     指定されたデジタルボタンの何れかが新たに開放されたなら真を返します。
*/
bool HasHidControllerAnyButtonsUp(nn::hid::NpadButtonSet buttons) NN_NOEXCEPT;
