﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os.h>

#include "IrSensorModeState.h"

struct CameraViewer {
    // 各サイズの画像に対してのテクスチャデータ
    nn::gfx::Texture texture[5];
    nn::gfx::TextureView textureView[5];
    nn::gfx::DescriptorSlot textureDescriptor[5];

    nn::gfx::Sampler sampler;
    nn::gfx::DescriptorSlot samplerDescriptor;
    nn::gfx::Buffer copiedImageBuffer;
};

class ImageTransferModeState : public IrSensorModeState
{
public:
    NN_STATIC_ASSERT(nn::irsensor::ImageTransferProcessorWorkBufferSize320x240 % nn::os::MemoryPageSize == 0);
    static const size_t WorkMemorySize = nn::irsensor::ImageTransferProcessorWorkBufferSize320x240 + nn::irsensor::ImageTransferProcessorImageSize320x240;
    static const size_t WorkMemoryAlignement = nn::os::MemoryPageSize;

public:
    ImageTransferModeState(IrSensorMode* pNextProcessor, int* pMenuSelection, nn::irsensor::IrCameraHandle irCameraHandle, void* pWorkMemory, GraphicsSystem* pGraphicsSystem);
    ~ImageTransferModeState();

    void Start() NN_OVERRIDE;
    void Update() NN_OVERRIDE;
    void Render(nns::gfx::PrimitiveRenderer::Renderer* pPrimitiveRenderer, nn::gfx::CommandBuffer* pCommandBuffer, int index) NN_OVERRIDE;

private:
    void CopyImageBuffer(nn::gfx::CommandBuffer* pCommandBuffer);
    void RenderImageTransferProcessorState(nns::gfx::PrimitiveRenderer::Renderer* pPrimitiveRenderer,
        nn::gfx::CommandBuffer* pCommandBuffer,
        const int screenIndex) NN_NOEXCEPT;
private:
    nn::irsensor::ImageTransferProcessorFormat m_Format;
    nn::irsensor::ImageTransferProcessorState m_ImageTransferProcessorState;
    nn::irsensor::ImageTransferProcessorConfig m_ImageTransferProcessorConfig;
    void* m_pImageTransferWorkBuffer;
    void* m_pImageCopyWorkBuffer;

    Texture m_Textures[5];
    Sampler m_Sampler;
    nn::gfx::Buffer m_Buffer;
    int64_t m_PreviousSamplingNumber;
    GraphicsSystem* m_pGraphicsSystem;
};
