﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "IrSensorModeState.h"
#include <nn/irsensor/irsensor_MarkerPlaneEstimation.h>

class MarkerPlaneEstimation
{
public:
    MarkerPlaneEstimation(unsigned char* initMemory, size_t initMemorySize);
    ~MarkerPlaneEstimation();

    void Update(const nn::irsensor::PointList& currentPosition);
    void Render(nns::gfx::PrimitiveRenderer::Renderer* pPrimitiveRenderer, nn::gfx::CommandBuffer* pCommandBuffer, int index);

    void GetState(nn::irsensor::MarkerPlaneState** pOutState);

private:
    static const nn::irsensor::PointList StaticReferenceList;

    nn::irsensor::MarkerPlaneHandle m_Handle;
    uint8_t* m_pWorkBuffer;
    size_t m_WorkBufferSize;
    nn::irsensor::MarkerPlaneState m_State;
};
