﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "IrSensorModeState.h"
#include <nn/irsensor/irsensor_AdaptiveClusteringProcessor.h>
#include <nn/mem.h>
#include "MarkerPlaneEstimation.h"

class AdaptiveClusteringModeState : public IrSensorModeState
{
public:
    AdaptiveClusteringModeState(IrSensorMode* pNextProcessor, int* pMenuSelection, nn::irsensor::IrCameraHandle irCameraHandle);
    ~AdaptiveClusteringModeState();

    void Start() NN_OVERRIDE;
    void Update() NN_OVERRIDE;
    void Render(nns::gfx::PrimitiveRenderer::Renderer* pPrimitiveRenderer, nn::gfx::CommandBuffer* pCommandBuffer, int index) NN_OVERRIDE;

private:
    static const size_t MemoryHeapSize = 64 * 1024;

private:
    nn::irsensor::AdaptiveClusteringProcessorState  m_AdaptiveClusteringProcessorState;
    nn::irsensor::AdaptiveClusteringProcessorConfig m_AdaptiveClusteringProcessorConfig;
    int64_t m_lastSamplingNumber;

    nn::mem::StandardAllocator m_Allocator;
    char m_Heap[MemoryHeapSize];
    uint8_t* m_pWorkBuffer;

    MarkerPlaneEstimation* m_pMarkerPlaneEstimation;
};
