﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "ImguiDemo_SixAxis.h"

#if defined(NN_BUILD_TARGET_PLATFORM_OS_NN)

#include <nn/nn_Log.h>
#include <nn/hid/hid_SixAxisSensor.h>
#include <nn/hid/hid_NpadSixAxisSensor.h>
#include <nn/hid/hid_NpadJoyDual.h>


bool InitializeSixAxis(
    nn::hid::SixAxisSensorHandle* pOutHandle,
    const nn::hid::NpadIdType& npadIdType,
    int index)
{
    nn::hid::SixAxisSensorHandle handleArray[nn::hid::NpadSixAxisSensorHandleCountMax];

    int sixAxisSensorHandleCount = nn::hid::GetSixAxisSensorHandles(
        handleArray, nn::hid::NpadSixAxisSensorHandleCountMax,
        npadIdType, nn::hid::NpadStyleJoyDual::Mask);

    if (sixAxisSensorHandleCount > index)
    {
        nn::hid::SixAxisSensorHandle handle = handleArray[index];

        nn::hid::StartSixAxisSensor(handle);
        nn::hid::SetGyroscopeZeroDriftMode(
            handle,
            nn::hid::GyroscopeZeroDriftMode_Standard);

        *pOutHandle = handle;
        return true;
    }

    return false;
}

void FinalizeSixAxis(nn::hid::SixAxisSensorHandle handle)
{
    nn::hid::StopSixAxisSensor(handle);
}

bool UpdateSixAxis(
    nn::hid::SixAxisSensorState* pOutSixAxisSensorState,
    nn::hid::SixAxisSensorHandle handle)
{
    int stateCount = nn::hid::GetSixAxisSensorStates(
        pOutSixAxisSensorState, 1, handle);
    return (stateCount > 0);
}


#endif
