﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nns/gfx/gfx_GraphicsFramework.h>
#include <nn/gfx/util/gfx_DebugFontTextWriter.h>

typedef void(*PrintFunc)(nn::gfx::util::DebugFontTextWriter*);

class IgeGraphicsSystem
{
public:
    explicit IgeGraphicsSystem(PrintFunc pPrintFunc);
    ~IgeGraphicsSystem();

    void ProcessFrame() NN_NOEXCEPT;

private:
    void Initialize() NN_NOEXCEPT;
    void Finalize() NN_NOEXCEPT;
    static void MakeCommand(nns::gfx::GraphicsFramework* pGraphicsFramework, int bufferIndex, void* pUserData) NN_NOEXCEPT;

private:
    nns::gfx::GraphicsFramework m_Framework;
    nn::gfx::util::DebugFontTextWriter m_Writer;

    PrintFunc m_pPrintFunc;
    uint8_t* m_pDebugFontHeap;
};
