﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nns/hidbus/hidbus_Ronde.h>

enum HidbusState
{
    HidbusState_NotGotHandle = 0,
    HidbusState_GotHandle = 1,
    HidbusState_Enabled = 2,
    HidbusState_End = 3,
};

struct RondeInfo
{
    HidbusState state;
    uint8_t     uniqueId[12];
    uint16_t    fwVer;
    int32_t     maxPush;
    int32_t     maxPull;
    int32_t     zeroMax;
    int32_t     zeroMin;
    int16_t     sensor;
    int16_t     thermistor;
    uint64_t    samplingNumber;

    nns::hidbus::RondeInternalErrorInfo errorInfo;
};

void RondeThread(void* arg);
RondeInfo GetRondeInfo();
