﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/hid/hid_Vibration.h>

#include "GraphicsSystem.h"
#include "Box.h"
#include "DumpedVibrationGenerator.h"

class Demo
{
    NN_DISALLOW_COPY(Demo);
    NN_DISALLOW_MOVE(Demo);

public:
    static Demo& GetInstance() NN_NOEXCEPT;
    void Initialize() NN_NOEXCEPT;
    void Update() NN_NOEXCEPT;
    void Draw(GraphicsSystem* pGraphicsSystem) const NN_NOEXCEPT;

private:
    Demo() NN_NOEXCEPT {}
    ~Demo() NN_NOEXCEPT {}
    void UpdateButton() NN_NOEXCEPT;
    void UpdateSensor() NN_NOEXCEPT;
    void UpdateDebugPad() NN_NOEXCEPT;
    void DrawEnv(GraphicsSystem* pGraphicsSystem) const NN_NOEXCEPT;
    void DrawObject(GraphicsSystem* pGraphicsSystem) const NN_NOEXCEPT;
    void DrawVibrationValue(GraphicsSystem* pGraphicsSystem) const NN_NOEXCEPT;
    void DrawVibrationGenerator(GraphicsSystem* pGraphicsSystem) const NN_NOEXCEPT;

private:
    bool m_IsGraphicsEnabled = false;               //!< デバッグ情報を表示するか否かのフラグ
    int m_VibrationPattern = 0;                     //!< 再生する振動のパターン
    static const int VibrationDeviceCountMax = 2;   //!< 振動デバイスの数
    static const int BoxCountMax = 2;               //!< 表示するBoxの数

    Box m_Box[BoxCountMax];
    nn::hid::VibrationNodeConnection m_ConnectionFromBoxToMixer[BoxCountMax];
    nn::hid::VibrationMixer          m_Mixer;
    nn::hid::VibrationTarget         m_Target[VibrationDeviceCountMax];
    nn::hid::VibrationNodeConnection m_ConnectionFromMixerToTarget[VibrationDeviceCountMax];

};

