﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/hid/hid_Vibration.h>
#include "GraphicsSystem.h"
#include "DumpedVibrationGenerator.h"

struct Line
{
    float Pos[4];         //!< 線の始点X、始点Y、終点X、終点Yの座標
    float Intensity;      //!< 線の輝度
    bool  LineAttacked;   //!< 線が触れられているかどうか
};

class Box
{
    NN_DISALLOW_COPY(Box);
    NN_DISALLOW_MOVE(Box);

public:
    Box() NN_NOEXCEPT;
    ~Box() NN_NOEXCEPT
    {
        //何もしない
    }

    //!< 位置を設定します。
    void SetPos(float baseX, float baseY) NN_NOEXCEPT;
    void Update(float x, float y) NN_NOEXCEPT;
    void Draw(nns::gfx::PrimitiveRenderer::Renderer* pPrimitiveRenderer, nn::gfx::CommandBuffer* pCommandBuffer) const NN_NOEXCEPT;

    //!< 振動の出力を取得します
    nn::hid::VibrationMixer* GetVibrationOutput() NN_NOEXCEPT
    {
        return &m_Mixer;
    }

    //!< 振動パラメータを設定します。
    void SetVibrationParameter(const DumpedVibrationParameter& pLowPara, const DumpedVibrationParameter& pHighPara) NN_NOEXCEPT
    {
        for (int i = 0; i < LineCountMax; i++)
        {
            m_Generator[i].SetParameter(pLowPara,0);
            m_Generator[i].SetParameter(pHighPara,1);
        }
    }

    //!< 振動させる
    void PlayVibration() NN_NOEXCEPT
    {
        m_Generator[0].Play();
    }

private:
    static const int   LineCountMax = 5; //!< 線の数
    static const float LineLength;       //!< 線の長さ
    static const float LineClearance;    //!< 線同士の距離

    int m_PrePosX = 0;                   //!< 前回のポインタのX座標
    Line m_Line[LineCountMax];

    nn::hid::VibrationMixer m_Mixer;
    nn::hid::VibrationNodeConnection m_Connection[LineCountMax];
    DumpedVibrationGenerator m_Generator[LineCountMax];
};

