﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/hid/hid_NpadJoy.h>

#include "NpadController.h"

//!< JoyDualStyleに特化した処理を記述した NpadControllerBase の派生クラスです。
class NpadJoyDualController : public NpadControllerBase
{
    NN_DISALLOW_COPY(NpadJoyDualController);
    NN_DISALLOW_MOVE(NpadJoyDualController);

public:
    NpadJoyDualController(nn::hid::NpadIdType npadId, const char* name) NN_NOEXCEPT
        : NpadControllerBase(npadId, name)
    {}

    virtual ~NpadJoyDualController() NN_NOEXCEPT NN_OVERRIDE{}

    virtual nn::hid::NpadStyleSet GetStyleSet() const NN_NOEXCEPT NN_OVERRIDE
    {
        return nn::hid::NpadStyleJoyDual::Mask;
    }

protected:
    virtual void UpdateButtons() NN_NOEXCEPT NN_OVERRIDE;
};
