﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>

#include <nn/hid/hid_NpadSixAxisSensor.h>
#include <nn/hid/system/hid_UniquePad.h>
#include <nn/hid/system/hid_SixAxisSensorCalibration.h>

#include "HidSixAxisSensorCalibration_IState.h"

// フォーカスしたコントローラの特徴値
struct FocusedPadFeatures
{
    ::nn::hid::NpadIdType npadId;
    ::nn::hid::NpadButtonSet buttons;
    ::nn::hid::SixAxisSensorHandle handle;
    ::nn::hid::system::UniqueSixAxisSensorHandle uniquePadHandle;
    ::nn::hid::system::UniquePadId uniquePadId;
};

// コンテキスト情報
class Context
{
    NN_DISALLOW_COPY(Context);
    NN_DISALLOW_MOVE(Context);

public:
    Context() NN_NOEXCEPT;

    void HandleConnection() NN_NOEXCEPT;

    void Update() NN_NOEXCEPT;

    void SetState(IState* pState) NN_NOEXCEPT;

    void SetFocusedPadFeatures(const FocusedPadFeatures& features) NN_NOEXCEPT;

    FocusedPadFeatures GetFocusedPadFeatures() const NN_NOEXCEPT;

private:

    IState* m_pState;

    FocusedPadFeatures m_FocusedPadFeatures;
};
