﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Macro.h>
#include <nn/nn_Log.h>

#include "HidSixAxisSensorCalibration_Context.h"
#include "HidSixAxisSensorCalibration_State.h"

Context::Context() NN_NOEXCEPT
    : m_pState(&State::s_InitialState)
{
    // 何もしない
}

void Context::HandleConnection() NN_NOEXCEPT
{
    NN_LOG("UniquePad Connection detected.\n");
    // Do something, if needed.
}

void Context::Update() NN_NOEXCEPT
{
    m_pState->Update(this);
}

void Context::SetState(IState* pState) NN_NOEXCEPT
{
    if (m_pState)
    {
        m_pState->Exit(this);
    }

    m_pState = pState;

    m_pState->Enter(this);
}

void Context::SetFocusedPadFeatures(const FocusedPadFeatures& features) NN_NOEXCEPT
{
    m_FocusedPadFeatures = features;
}

FocusedPadFeatures Context::GetFocusedPadFeatures() const NN_NOEXCEPT
{
    return m_FocusedPadFeatures;
}
