﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Assert.h>
#include <nn/nn_Log.h>
#include <nn/nn_Macro.h>
#include <nn/result/result_HandlingUtility.h>

#include <nn/hid/system/hid_Result.h>
#include <nn/hid/system/hid_SixAxisSensorAccurateCalibration.h>

#include "HidSixAxisSensorAccurateCalibration_CalibratingState.h"
#include "HidSixAxisSensorAccurateCalibration_InitialState.h"
#include "HidSixAxisSensorAccurateCalibration_State.h"

// InitialState クラス
InitialState::InitialState() NN_NOEXCEPT
{
    // 何もしない
}

InitialState::~InitialState() NN_NOEXCEPT
{
    // 何もしない
}

void InitialState::Update(Context* pContext) NN_NOEXCEPT
{
    const auto TriggerButtons = pContext->GetTriggerButtons();
    const auto Handle = pContext->GetUniqueSixAxisSensorHandle();

    if (TriggerButtons.Test<::nn::hid::NpadButton::A>())
    {
        NN_LOG("A : StartConsoleSixAxisSensorUserCalibration\n");
        auto result = ::nn::hid::system::StartSixAxisSensorAccurateUserCalibration(Handle);
        if (::nn::hid::system::ResultSixAxisSensorAccurateNotSupported::Includes(result))
        {
            NN_ABORT("StartSixAxisSensorAccurateUserCalibration() failed.\n");
        }

        // CalibratingState に遷移
        pContext->SetState(&State::s_CalibratingState);
    }
    if (TriggerButtons.Test<::nn::hid::NpadButton::B>())
    {
        NN_LOG("B : CancelConsoleSixAxisSensorUserCalibration\n");
        ::nn::hid::system::CancelSixAxisSensorAccurateUserCalibration(Handle);
    }
    if (TriggerButtons.Test<::nn::hid::NpadButton::X>())
    {
        NN_LOG("X : ResetConsoleSixAxisSensorCalibrationValues\n");
        ::nn::hid::system::ResetSixAxisSensorCalibrationValues(Handle);
    }
}

void InitialState::Enter(Context* pContext) NN_NOEXCEPT
{
    NN_LOG("[%s] InitialState\n", __FUNCTION__);
}

void InitialState::Exit(Context* pContext) NN_NOEXCEPT
{
    NN_LOG("[%s] InitialState\n", __FUNCTION__);
}

