﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>

#include <nn/hid/hid_Npad.h>
#include <nn/hid/system/hid_SixAxisSensorCalibration.h>

#include "HidSixAxisSensorAccurateCalibration_IState.h"

// コンテキスト情報
class Context
{
    NN_DISALLOW_COPY(Context);
    NN_DISALLOW_MOVE(Context);

public:
    Context() NN_NOEXCEPT;

    void Update() NN_NOEXCEPT;

    void SetState(IState* pState) NN_NOEXCEPT;

    void Initialize() NN_NOEXCEPT;

    ::nn::hid::NpadButtonSet GetTriggerButtons() const NN_NOEXCEPT;

    ::nn::hid::system::UniqueSixAxisSensorHandle GetUniqueSixAxisSensorHandle() const NN_NOEXCEPT;

    void PrintCalibrationStatus() const NN_NOEXCEPT;

private:

    IState* m_pState;

    ::nn::hid::system::UniqueSixAxisSensorHandle m_UniqueSixAxisSensorHandle;
    ::nn::hid::NpadButtonSet m_LastButtons;
    ::nn::hid::NpadButtonSet m_CurrentButtons;
};
