﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/hid/hid_Palma.h>

/**
 * @brief サンプルで扱う Activity の種類です。
 */
enum SampleActivityPattern
{
    SampleActivityPattern_1,
    SampleActivityPattern_2,
    SampleActivityPattern_Max
};

/**
 * @brief Palma デバイスの Play Log の項目の例です。
 */
enum SamplePlayLogFieldType
{
    SamplePlayLogFieldType_Index0,
    SamplePlayLogFieldType_Index1
};

/**
 * @brief Palma デバイスのコントローラを初期化します。
 */
void InitializePalmaDeviceController() NN_NOEXCEPT;

/**
* @brief Palma デバイスのコントローラを終了します。
*/
void FinalizePalmaDeviceController() NN_NOEXCEPT;

/**
* @brief Palma デバイスをアクティベートします。
*/
void ActivatePalmaDevice(int index, const nn::hid::NpadIdType& id) NN_NOEXCEPT;

/**
* @brief Palma デバイスを無効にします。
*/
void DeactivatePalmaDevice(int index) NN_NOEXCEPT;

/**
* @brief Palma デバイスの状態を更新します。
*/
void UpdatePalmaDevices() NN_NOEXCEPT;

/**
* @brief すべての Palma デバイスを切断します。内部で DeactivatePalmaDevice が呼ばれます。
*/
void DetachAllPalma() NN_NOEXCEPT;

/**
* @brief Palma デバイスの Activity を再生します。
*/
int PlayPalmaActivity(int index) NN_NOEXCEPT;

/**
* @brief Palma デバイスに Activity を書き込みます。
*/
int WritePalmaActivity(int index, SampleActivityPattern pattern) NN_NOEXCEPT;

/**
 * @brief Palma デバイスの各種データを読み込みます。
 */
int GetPalmaProperties(int index) NN_NOEXCEPT;

/**
 * @brief Palma デバイスのアプリケーションセクションからデータを読み込みます。
 */
int ReadPalmaApplicationSection(int index) NN_NOEXCEPT;

/**
 * @brief Palma デバイスのアプリケーションセクションにデータを書き込みます。
 */
int WritePalmaApplicationSection(int index) NN_NOEXCEPT;

/**
* @brief Palma デバイスの FrModeType に値を書き込みます。
*/
int SetPalmaFrModeType(int index) NN_NOEXCEPT;

/**
* @brief Palma デバイスの PlayLog を読み込みます。
*/
int ReadPalmaPlayLog(int index, SamplePlayLogFieldType fieldType) NN_NOEXCEPT;

/**
* @brief Palma デバイスの PlayLog をゼロクリアします。
*/
int ResetPalmaPlayLog(int index, SamplePlayLogFieldType fieldType) NN_NOEXCEPT;

/**
* @brief Palma をペアリングします。
*/
void PairPalmaDevice(int index) NN_NOEXCEPT;

/**
 * @brief Palma デバイスの機能を一時停止/再開します。
 */
int SuspendPalmaFeature(int index, bool isSuspended) NN_NOEXCEPT;
