﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/hid/hid_Npad.h>

#include "HidNpadIntegrate_PluginBase.h"

struct NpadCommonState
{
    nn::hid::NpadButtonSet buttons;
    nn::hid::AnalogStickState analogStickL;
    nn::hid::AnalogStickState analogStickR;
};

class NpadStylePluginBase : public PluginBase
{
    NN_DISALLOW_COPY(NpadStylePluginBase);
    NN_DISALLOW_MOVE(NpadStylePluginBase);

public:
    NpadStylePluginBase() NN_NOEXCEPT {}

    virtual ~NpadStylePluginBase() NN_NOEXCEPT NN_OVERRIDE {}

    virtual void Initialize() NN_NOEXCEPT NN_OVERRIDE
    {
        static int count;
        m_StyleIndex = count++;
    }

    virtual void Finalize() NN_NOEXCEPT NN_OVERRIDE {}

    virtual bool IsEnableNpadStyle(nn::hid::NpadStyleSet style) NN_NOEXCEPT = 0;

    virtual nn::hid::NpadStyleSet  GetNpadStyleSet() NN_NOEXCEPT = 0;

    virtual NpadCommonState GetNpadButtonState(nn::hid::NpadIdType id) NN_NOEXCEPT = 0;

    void WriteText(nn::gfx::util::DebugFontTextWriter* pTextWriter,
                    const float OffsetX, const float OffsetY,
                    const nn::util::Unorm8x4 TextColor, const char* str) NN_NOEXCEPT
    {
        pTextWriter->SetTextColor(TextColor);
        pTextWriter->SetCursor(OffsetX, OffsetY);
        pTextWriter->Print(str);
    }

    virtual void WriteNpadLeftKey(nn::gfx::util::DebugFontTextWriter* pTextWriter,
                       const nn::hid::NpadIdType NpadId,
                       const float OffsetX, const float OffsetY) NN_NOEXCEPT = 0;

    virtual void WriteNpadRightKey(nn::gfx::util::DebugFontTextWriter* pTextWriter,
                       const nn::hid::NpadIdType NpadId,
                       const float OffsetX, const float OffsetY) NN_NOEXCEPT = 0;

    virtual void WriteNpadExtendedKey(nn::gfx::util::DebugFontTextWriter* pTextWriter,
                       const nn::hid::NpadIdType NpadId,
                       const float OffsetX, const float OffsetY) NN_NOEXCEPT = 0;

    uint32_t GetStyleIndex() NN_NOEXCEPT
    {
        return m_StyleIndex;
    }

protected:
    uint32_t m_StyleIndex;

};
