﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/hid/hid_NpadJoy.h>

#include "HidNpadIntegrate_Main.h"
#include "HidNpadIntegrate_PluginManager.h"
#include "HidNpadIntegrate_StylePluginBase.h"

class StyleJoyLeft : public NpadStylePluginBase
{
    NN_DISALLOW_COPY(StyleJoyLeft);
    NN_DISALLOW_MOVE(StyleJoyLeft);

public:
    StyleJoyLeft() NN_NOEXCEPT {}

    virtual ~StyleJoyLeft() NN_NOEXCEPT NN_OVERRIDE {}

    virtual bool IsEnableNpadStyle(nn::hid::NpadStyleSet style) NN_NOEXCEPT NN_OVERRIDE
    {
        return style.Test<nn::hid::NpadStyleJoyLeft>();
    }

    virtual nn::hid::NpadStyleSet GetNpadStyleSet() NN_NOEXCEPT NN_OVERRIDE
    {
        return nn::hid::NpadStyleJoyLeft::Mask;
    }

    virtual NpadCommonState GetNpadButtonState(nn::hid::NpadIdType id) NN_NOEXCEPT NN_OVERRIDE
    {
        nn::hid::NpadJoyLeftState keyState;
        nn::hid::GetNpadState(&keyState, id);
        NpadCommonState state = { keyState.buttons ,
                                  keyState.analogStickL ,
                                  keyState.analogStickR};
        return state;
    }

    void WriteNpadLeftKey(nn::gfx::util::DebugFontTextWriter* pTextWriter,
                               const nn::hid::NpadIdType NpadId,
                               const float OffsetX,
                               const float OffsetY) NN_NOEXCEPT NN_OVERRIDE
    {
        const int16_t Int16Max = std::numeric_limits<int16_t>::max();
        nn::util::Unorm8x4 textColor = Color::White;
        NpadCommonState npadState = GetNpadButtonSet(NpadId);
        pTextWriter->SetScale(1.0f, 1.0f);

        WriteText(pTextWriter, OffsetX + 25, OffsetY + 60,
                    npadState.buttons.Test<nn::hid::NpadButton::Up>()
                                                    ? Color::Orange : textColor, "|");
        WriteText(pTextWriter, OffsetX + 25, OffsetY + 100,
                    npadState.buttons.Test<nn::hid::NpadButton::Down>()
                                                    ? Color::Orange : textColor, "|");
        WriteText(pTextWriter, OffsetX + 5, OffsetY + 80,
                    npadState.buttons.Test<nn::hid::NpadButton::Left>()
                                                    ? Color::Orange : textColor, "--");
        WriteText(pTextWriter, OffsetX + 40, OffsetY + 80,
                    npadState.buttons.Test<nn::hid::NpadButton::Right>()
                                                    ? Color::Orange : textColor, "--");

        WriteText(pTextWriter, OffsetX + 75, OffsetY + 60,
                    npadState.buttons.Test<nn::hid::NpadButton::Minus>()
                                                    ? Color::Orange : textColor, "-");

        WriteText(pTextWriter, OffsetX + 5, OffsetY + 30,
                    npadState.buttons.Test<nn::hid::NpadButton::ZL>()
                                                    ? Color::Orange : textColor, "ZL");
        WriteText(pTextWriter, OffsetX + 35, OffsetY + 30,
                    npadState.buttons.Test<nn::hid::NpadButton::L>()
                                                    ? Color::Orange : textColor, "L");

        WriteText(pTextWriter, OffsetX + 73 + 20 * npadState.analogStickL.x / Int16Max,
                    OffsetY + 105 - 20 * npadState.analogStickL.y / Int16Max,
                    npadState.buttons.Test<nn::hid::NpadButton::StickL>()
                                                    ? Color::Orange : textColor, "*");

        pTextWriter->SetTextColor(textColor);
        pTextWriter->SetScale(0.7f, 0.7f);
        pTextWriter->SetCursor(OffsetX + 5, OffsetY + 145);
        pTextWriter->Print("(%06d, %06d)",
                        npadState.analogStickL.x, npadState.analogStickL.y);
    }

    void WriteNpadRightKey(nn::gfx::util::DebugFontTextWriter* pTextWriter,
                               const nn::hid::NpadIdType NpadId,
                               const float OffsetX,
                               const float OffsetY) NN_NOEXCEPT NN_OVERRIDE
    {
        NN_UNUSED(pTextWriter);
        NN_UNUSED(NpadId);
        NN_UNUSED(OffsetX);
        NN_UNUSED(OffsetY);
    }

    virtual void WriteNpadExtendedKey(nn::gfx::util::DebugFontTextWriter* pTextWriter,
                       const nn::hid::NpadIdType NpadId,
                       const float OffsetX, const float OffsetY) NN_NOEXCEPT NN_OVERRIDE
    {
        nn::util::Unorm8x4 textColor = Color::White;
        NpadCommonState npadState = GetNpadButtonSet(NpadId);
        pTextWriter->SetScale(1.0f, 1.0f);

        pTextWriter->SetTextColor(npadState.buttons.Test<nn::hid::NpadJoyButton::LeftSL>()
                                                                ? Color::Orange : textColor);
        pTextWriter->SetCursor(OffsetX + 55, OffsetY + 30);
        pTextWriter->Print("SL");

        pTextWriter->SetTextColor(npadState.buttons.Test<nn::hid::NpadJoyButton::LeftSR>()
                                                                ? Color::Orange : textColor);
        pTextWriter->SetCursor(OffsetX + 85, OffsetY + 30);
        pTextWriter->Print("SR");
    }

};

namespace {
SET_PLUGIN(StyleJoyLeft, "NpadJoyLeft");
}
