﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <sstream>

#include <nn/hid.h>

#include <nn/nn_Assert.h>
#include <nn/hid/hid_Npad.h>

#include "HidNpadIntegrate_Color.h"
#include "HidNpadIntegrate_MenuBase.h"

const int NpadIdMax = 5;
const int NpadStyleMax = 5;

class NpadStyleStatus : public ReadWriteBase
{
    NN_DISALLOW_COPY(NpadStyleStatus);
    NN_DISALLOW_MOVE(NpadStyleStatus);

public:
    NpadStyleStatus(nn::hid::NpadStyleSet* pNpadStyle, int m_index) NN_NOEXCEPT;
    virtual void operator()(std::stringstream& sstr) NN_NOEXCEPT NN_OVERRIDE;
    virtual void operator()(int8_t delta) NN_NOEXCEPT NN_OVERRIDE;

private:
    nn::hid::NpadStyleSet* m_pNpadStyle;
    int m_index;
};


class NpadIdType : public ReadWriteBase
{
    NN_DISALLOW_COPY(NpadIdType);
    NN_DISALLOW_MOVE(NpadIdType);

public:
    NN_IMPLICIT NpadIdType(nn::hid::NpadIdType* pNpadId) NN_NOEXCEPT;
    virtual void operator()(std::stringstream& sstr) NN_NOEXCEPT NN_OVERRIDE;
    virtual void operator()(int8_t delta) NN_NOEXCEPT NN_OVERRIDE;

private:
    nn::hid::NpadIdType* m_pNpadId;
};

class CallingApi : public ReadWriteBase
{
    NN_DISALLOW_COPY(CallingApi);
    NN_DISALLOW_MOVE(CallingApi);

public:
    CallingApi(int* pNextProcessor, int* pMenuSelection) NN_NOEXCEPT;
    virtual void operator()(std::stringstream& sstr) NN_NOEXCEPT NN_OVERRIDE;
    virtual void operator()(int8_t delta) NN_NOEXCEPT NN_OVERRIDE;

private:
    int* m_pNextProcessor;
    int* m_pMenuSelection;
};
