﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "HidNpadIntegrate_PluginManager.h"
#include "HidNpadIntegrate_SettingApi.h"

NpadStyleStatus::NpadStyleStatus(nn::hid::NpadStyleSet* pNpadStyle, int index) NN_NOEXCEPT
: m_pNpadStyle(pNpadStyle)
, m_index(index)
{
}

void NpadStyleStatus::operator()(std::stringstream& sstr) NN_NOEXCEPT
{
    nn::hid::NpadStyleSet styleMask = GetPluginManager().GetNpadStyle(m_index)->GetNpadStyleSet();
    sstr << (((*m_pNpadStyle) & styleMask) == styleMask ?
            "Valid" :
            "Invalid");
}

void NpadStyleStatus::operator()(int8_t delta) NN_NOEXCEPT
{
    NN_UNUSED(delta);
    nn::hid::NpadStyleSet styleMask = GetPluginManager().GetNpadStyle(m_index)->GetNpadStyleSet();
    *m_pNpadStyle ^= styleMask;
}

NpadIdType::NpadIdType(nn::hid::NpadIdType* pNpadId) NN_NOEXCEPT
: m_pNpadId(pNpadId)
{
}

void NpadIdType::operator()(std::stringstream& sstr) NN_NOEXCEPT
{
    sstr << *m_pNpadId;
}

void NpadIdType::operator()(int8_t delta) NN_NOEXCEPT
{
    if(((*m_pNpadId == nn::hid::NpadId::No1) && (delta == -1)) ||
       ((*m_pNpadId == nn::hid::NpadId::No4) && (delta == 1)))
    {
        delta = 0;
    }
    *m_pNpadId += static_cast<nn::hid::NpadIdType>(delta);
}

CallingApi::CallingApi(int* pNextProcessor, int* pMenuSelection) NN_NOEXCEPT
    : m_pNextProcessor(pNextProcessor)
    , m_pMenuSelection(pMenuSelection)
{
}

void CallingApi::operator()(std::stringstream& sstr) NN_NOEXCEPT
{
    SettingApiPluginBase* pSettingApi = GetPluginManager().GetSettingApi(*m_pNextProcessor);
    GetPluginManager().GetNpadStylePluginCount();
    sstr << pSettingApi->GetName();
}

void CallingApi::operator()(int8_t delta) NN_NOEXCEPT
{
    int8_t mode = static_cast<int8_t>(*m_pNextProcessor) + delta;
    *m_pNextProcessor = static_cast<int>(
        std::min(
            std::max(mode, static_cast<int8_t>(0)),
            static_cast<int8_t>(GetPluginManager().GetSettingApiPluginCount() - 1)
        )
    );
    *m_pMenuSelection = 0;
}
