﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// ハンドアナリシスユーティリティの構造体
struct PolygonProperties
{
    float perimeter;   // ポリゴンの外周
    float signedArea;  // ポリゴンの符号付面積
    nn::util::Float2 perimeterCentroid; //  ポリゴンの外周上にある点の重心
    nn::util::Float2 areaCentroid;      // ポリゴン内の点の重心
};

// ポリゴンの特性を算出
void ComputePolygonProperties(
    PolygonProperties* pPolygonProperties,
    const nn::util::Float2* pPolygonPoints,
    size_t polygonPointCount) NN_NOEXCEPT;


// 与えられた点から凸包を抽出
void ExtractConvexHull(
    std::vector<size_t>& convexHullIndices,
    const std::vector<nn::util::Float2>& OneTurnSilhouette) NN_NOEXCEPT;

