﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/gfx.h>
#include <nn/nn_Macro.h>
#include <nn/gfx/util/gfx_DebugFontTextWriter.h>

#include "HidNpadIntegrate_ApplicationHeap.h"
#include "HidNpadIntegrate_GraphicsSystem.h"

class FontSystem
{
    NN_DISALLOW_COPY(FontSystem);
    NN_DISALLOW_MOVE(FontSystem);

public:
    FontSystem() NN_NOEXCEPT;

    void Initialize(
        ApplicationHeap* pApplicationHeap,
        GraphicsSystem* pGraphicsSystem) NN_NOEXCEPT;

    void Finalize() NN_NOEXCEPT;

    nn::gfx::util::DebugFontTextWriter& GetDebugFontTextWriter() NN_NOEXCEPT;

private:
    ApplicationHeap* m_pApplicationHeap;

    GraphicsSystem* m_pGraphicsSystem;

    void* m_pDebugFontMemory;

    nn::gfx::MemoryPool m_DebugFontMemoryPool;
    void* m_pDebugFontMemoryPool;

    nn::gfx::util::DebugFontTextWriter m_DebugFontTextWriter;
};
