﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/mem/mem_StandardAllocator.h>

class ApplicationHeap
{
    NN_DISALLOW_COPY(ApplicationHeap);
    NN_DISALLOW_MOVE(ApplicationHeap);

public:
    ApplicationHeap() NN_NOEXCEPT;

    void Initialize(size_t size) NN_NOEXCEPT;

    void Finalize() NN_NOEXCEPT;

    nn::mem::StandardAllocator* GetApplicationHeapHandle() NN_NOEXCEPT;

    void* Allocate(size_t size, size_t alignment) NN_NOEXCEPT;

    void* Allocate(size_t size) NN_NOEXCEPT;

    void Deallocate(void* ptr) NN_NOEXCEPT;

private:
    void* m_pMemoryHeap;
    nn::mem::StandardAllocator m_ApplicationHeapHandle;
};
