﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "./HidControllerSequence_Main.h"

class StartSceneThread : public ThreadState
{
private:
    uint64_t            m_FrameCount;
    std::string         m_StartText;
    nn::util::Float2    m_StartTextPos;
    nn::util::Float2    m_TitleLogoPos;
    nns::hid::ButtonSet m_WaitButtons;

    nns::gfx::PrimitiveRenderer::Renderer*  m_pRenderer;
    nn::gfx::util::DebugFontTextWriter*     m_pTextWriter;
    nn::gfx::CommandBuffer*                 m_pCommand;
public:
    StartSceneThread();
    StartSceneThread(const char* name, nn::os::ThreadFunction func);

    void Initialize();
    void Update();
    void Draw();
    void Finalize();
};
