﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "./HidControllerSequence_Main.h"
#include "./HidControllerSequence_Thread.h"

//! @brief ダイアログの生成情報
struct DialogInfo
{
    nn::util::Float2            Pos;                //!< ダイアログの座標
    nn::util::Float2            Size;               //!< ダイアログのサイズ
    int32_t                     CancelNum;          //!< キャンセル時に返される値
    std::string                 Title;              //!< ダイアログのタイトル
    std::string                 Message;            //!< ダイアログの本文
    std::vector<std::string>    Answer;             //!< ダイアログの選択肢
    CheckPatternSet             ControllerCheck;    //!< ダイアログ実行中もコントローラーの接続を監視するか

    //! @brief ダイアログ情報のデフォルト値を設定します
    void SetDefault();
};

//---------------------------------------------------------------------------
//! @brief ダイアログを表示します
//! @param[in] info     ダイアログの設定情報
//! @returns            選択された項目のインデックス
//---------------------------------------------------------------------------
int32_t ShowDialog(const DialogInfo& info);

//---------------------------------------------------------------------------
//! @brief ダイアログを表示します
//! @details 特定のNpadIdでのみ操作することが可能なダイアログを表示します
//! @param[in] info     ダイアログの設定情報
//! @param[in] npadId   ダイアログの操作を許可するコントローラーのNpadId
//! @param[in] single   許可されたコントローラーのみ入力を受け付けます
//! @returns            選択された項目のインデックス
//---------------------------------------------------------------------------
int32_t ShowDialog(const DialogInfo& info, const nn::hid::NpadIdType& npadId, bool single = true);
