﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "./HidControllerSequence_Main.h"

extern const nn::util::Color4u8 g_ControllerColorList[4];
extern const char* g_ControllerTextList[4];

struct CheckPattern
{
    typedef nn::util::BitFlagSet<32, CheckPattern>::Flag< 0> Single;                    //!< 1人プレイ時の呼び出し
    typedef nn::util::BitFlagSet<32, CheckPattern>::Flag< 1> PlayerCountShort;          //!< (マルチプレイ時) プレイヤー人数が不足している時
    typedef nn::util::BitFlagSet<32, CheckPattern>::Flag< 2> ChangeMasterController;    //!< マスターコントローラーが変更された
    typedef nn::util::BitFlagSet<32, CheckPattern>::Flag< 3> CallInterval;              //!< 5s呼び出し待機
    typedef nn::util::BitFlagSet<32, CheckPattern>::Flag< 4> Resume;                    //!< 再開時
    typedef nn::util::BitFlagSet<32, CheckPattern>::Flag< 5> LostMasterController;      //!< マスターコントローラーが消失した場合
    typedef nn::util::BitFlagSet<32, CheckPattern>::Flag< 6> LostController;            //!< 特定のコントローラーを消失した場合
    typedef nn::util::BitFlagSet<32, CheckPattern>::Flag< 7> NoneController;            //!< (マルチプレイ時) 全てのコントローラーが消失した場合
};

typedef nn::util::BitFlagSet<32, CheckPattern> CheckPatternSet;

//---------------------------------------------------------------------------
//! @brief 動作を続ける上で必要なコントローラーが接続されているか確認します
//! @param[in] CheckPattern  確認するパターン
//! @param[in] npadId       CheckPattern で LostController を設定している場合
//!                         どの NpadId のコントローラーを接続確認対象にするか
//! @returns                コントローラーサポートアプレットの呼び出しが必要な場合はtrueを返します
//---------------------------------------------------------------------------
bool CheckConnectController(const CheckPatternSet& CheckPattern, const nn::hid::NpadIdType* npadId = nullptr);

//---------------------------------------------------------------------------
//! @brief コントローラーサポートアプレットの呼び出しを行います
//! @param[out] outResult       呼び出し結果 (nullptr 以外を指定した場合)
//! @param[in]  playerCount     プレイヤーの人数
//---------------------------------------------------------------------------
nn::Result CallControllerSupportApplet(nn::hid::ControllerSupportResultInfo* resultInfo, int playerCount);
