﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/gll.h>

class Renderer
{
public:
    void Initialize();
    void Finalize();

    void Render( int frame );

private:
    GLuint m_hVertexShader;
    GLuint m_hFragmentShader;
    GLuint m_hProgram;
    GLuint m_hVao;
    GLuint m_hVertexBuffer;
    GLuint m_hUbo;
    int* m_pMapped;
};
