﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <common.glsl>
#include <skeleton_block.glsl>
#include <shape_block.glsl>
#include <view_block.glsl>

#define c_Local ( 0 )
#define c_World ( c_Local + 1 )

#define SKINNING            ( -1 )      // @@ id="skinning" choice="[-1, 8]" type="dynamic"
#define COORDINATE          ( c_Local ) // @@ id="coord" choice="c_Local, c_World" type="dynamic"

//--------------------------------------------------------------------------------------------------

#ifdef NN_G3D_VERTEX_SHADER

layout(location = 0)  in vec4   i_Position;     // @@ id="_p0"   hint="position0"
layout(location = 1)  in ivec4  i_Index0;       // @@ id="_i0"   hint="blendindex0"
layout(location = 2)  in ivec4  i_Index1;       // @@ id="_i1"   hint="blendindex1"
layout(location = 3)  in vec4   i_Weight0;      // @@ id="_w0"   hint="blendweight0"
layout(location = 4)  in vec4   i_Weight1;      // @@ id="_w1"   hint="blendweight1"

/* @@
    attrib_id="_p0"   label="位置座標"                    editable="false"
    attrib_id="_i0"   label="ブレンドインデックス1-4"     editable="false"
    attrib_id="_i1"   label="ブレンドインデックス5-8"     editable="false"
    attrib_id="_w0"   label="ブレンドウェイト1-4"         editable="false"
    attrib_id="_w1"   label="ブレンドウェイト5-8"         editable="false"
    interleave="_p0 _i0 _i1 _w0 _w1"
*/

#endif // NN_G3D_VERTEX_SHADER

#ifndef NN_G3D_GEOMETRY_SHADER

#endif // !NN_G3D_GEOMETRY_SHADER

#ifdef NN_G3D_FRAGMENT_SHADER

#endif // NN_G3D_FRAGMENT_SHADER

//--------------------------------------------------------------------------------------------------

//--------------------------------------------------------------------------------------------------

#ifdef NN_G3D_VERTEX_SHADER

void main()
{
#if COORDINATE == c_Local
    vec4 pos_w = vec4(0, 0, 0, 1);

    int skinning = SKINNING != -1 ? SKINNING : vtxSkinCount;
    if (skinning == 0)
    {
        // rigid body
        pos_w.xyz = NN_G3D_TRANSFORM_POS(shapeMtx, i_Position);
    }
    else if (skinning == 1)
    {
        // rigid skinning
        int offset = i_Index0.x * 3;
        pos_w.xyz = NN_G3D_TRANSFORM_POS_OFFSET(mtxPalette, offset, i_Position);
    }
    else if (skinning <= 4)
    {
        // smooth skinning [1, 4]
        for (int i = 0; i < skinning; ++i)
        {
            int offset = i_Index0[i] * 3;
            float weight = i_Weight0[i];
            pos_w.xyz += weight * NN_G3D_TRANSFORM_POS_OFFSET(mtxPalette, offset, i_Position);
        }
    }
    else if (skinning <= 8)
    {
        // smooth skinning [5, 8]
        for (int i = 0; i < 4; ++i)
        {
            int offset = i_Index0[i] * 3;
            float weight = i_Weight0[i];
            pos_w.xyz += weight * NN_G3D_TRANSFORM_POS_OFFSET(mtxPalette, offset, i_Position);
        }
        for (int i = 4; i < skinning; ++i)
        {
            int offset = i_Index1[i - 4] * 3;
            float weight = i_Weight1[i - 4];
            pos_w.xyz += weight * NN_G3D_TRANSFORM_POS_OFFSET(mtxPalette, offset, i_Position);
        }
    }
#elif COORDINATE == c_World
    vec4 pos_w = i_Position;
#endif

    vec4 pos_v = vec4(NN_G3D_TRANSFORM_POS(cameraMtx, pos_w), 1);
    vec4 out_pos = NN_G3D_PROJECT(projMtx, pos_v);

    gl_Position = out_pos;
}

#endif // NN_G3D_VERTEX_SHADER

//--------------------------------------------------------------------------------------------------

#ifdef NN_G3D_FRAGMENT_SHADER

void main()
{
}

#endif // NN_G3D_FRAGMENT_SHADER
