﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#define ENV_AS_MATERIAL

#include <common.glsl>
#include <shape_block.glsl>
#include <view_block.glsl>
#include <env_block.glsl>

// @@ group="clear_color_group" label="クリアカラー" order="6"
/* @@ clear_color_group:
    renderinfo="clear_color" type="float" count="3" default="0.5 0.5 0.5" optional="false" label="クリアカラー(接続時のみ編集可)"
*/

#ifdef NN_G3D_VERTEX_SHADER

layout(location = 0)  in vec4   i_Position;     // @@ id="_p0"   hint="position0"
layout(location = 1)  in vec3   i_Normal;       // @@ id="_n0"   hint="normal0"

/* @@
    attrib_id="_p0"   label="位置座標"                    editable="false"
    attrib_id="_n0"   label="法線"                        editable="false"
    interleave="_p0 _n0"
    interleave="" binarize="false"
*/

#endif // NN_G3D_VERTEX_SHADER

#ifndef NN_G3D_GEOMETRY_SHADER

NN_G3D_RASTER
{
    vec3 pos_v;
    vec3 nrm_w;
    vec3 nrm_v;
} nn_g3d_raster;

#endif // !NN_G3D_GEOMETRY_SHADER

#ifdef NN_G3D_FRAGMENT_SHADER

layout(location = 0)    out vec4 o_Color;

#endif // NN_G3D_FRAGMENT_SHADER

//--------------------------------------------------------------------------------------------------

#ifdef NN_G3D_VERTEX_SHADER

void main()
{
    vec4 pos_w = vec4(0, 0, 0, 1);
    vec3 nrm_w = vec3(0);

    // rigid body
    pos_w.xyz = NN_G3D_TRANSFORM_POS(shapeMtx, i_Position);
    nrm_w.xyz = NN_G3D_TRANSFORM_VEC(shapeMtx, i_Normal);

    vec4 pos_v = vec4(NN_G3D_TRANSFORM_POS(cameraMtx, pos_w), 1);
    vec3 nrm_v = NN_G3D_TRANSFORM_VEC(cameraMtx, nrm_w);

    gl_Position = NN_G3D_PROJECT(projMtx, pos_v);
    OUT.pos_v = pos_v.xyz;
    OUT.nrm_w = nrm_w;
    OUT.nrm_v = nrm_v;
}

#endif // NN_G3D_VERTEX_SHADER

//--------------------------------------------------------------------------------------------------

#ifdef NN_G3D_FRAGMENT_SHADER

void main()
{
    vec3 view = normalize(-IN.pos_v);
    vec3 nrm_w = normalize(IN.nrm_w);
    vec3 nrm_v = normalize(IN.nrm_v);

    // hemisphere
    vec3 up = vec3(0, 1, 0);
    float rate = dot(nrm_w, up) * 0.5 + 0.5;
    o_Color.rgb = rate * skyColor + (1 - rate) * groundColor;

    // directional
    o_Color.rgb += dirLightColor * clamp(dot(nrm_w, normalize(-dirLightDir)), 0, 1);

    o_Color.a = 1;
}

#endif // NN_G3D_FRAGMENT_SHADER
