﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

uniform samplerCubeArray envTex;        // @@ id="_r0" hint="reflection0" nostrip="true"
uniform sampler2D waterTex;             // @@ id="_w0" hint="water0" nostrip="true"
uniform sampler2DArrayShadow shadowTex; // @@ id="_d0" hint="depth0" nostrip="true"
uniform sampler2D colorTex;             // @@ id="_c0" hint="color0" nostrip="true"
uniform sampler2D gnormalTex;           // @@ id="_gn0" hint="gnormal0" nostrip="true"
uniform sampler2D lightTex;             // @@ id="_l0" hint="light0" nostrip="true"
uniform sampler2D depthTex;             // @@ id="_d1" hint="depth1" nostrip="true"

layout(std140) uniform Env           // @@ id="env"
{
    vec3 skyColor;                   // @@ id="sky_color" default="0.7 0.7 0.9" item="color" nostrip="true"
    vec3 groundColor;                // @@ id="ground_color" default="0.3 0.2 0.2" item="color" nostrip="true"

    vec3 dirLightDir;                // @@ id="dir_light_dir" default="-1 -1 -1" nostrip="true"
    vec3 dirLightColor;              // @@ id="dir_light_color" default="1 1 1" item="color" nostrip="true"

    vec4 intensity_amb_sha_ao_bake;  // @@ id="intensities" default="0.75 0.75 0.75 1.0" nostrip="true"
    float contrast;                  // @@ id="contrast" default="0.01" nostrip="true"
};

#ifdef ENV_AS_MATERIAL
// @@ block_id="env" type="material"

// @@ group="hemisphere_group" label="半球ライト" order="0"
/* @@ hemisphere_group:
    uniform_id="sky_color"          order="1"   label="スカイカラー"
    uniform_id="ground_color"       order="2"   label="グラウンドカラー"
*/

// @@ group="directional_group" label="ディレクショナルライト" order="1"
/* @@ directional_group:
    uniform_id="dir_light_dir"      order="1"   label="ライト方向"
    uniform_id="dir_light_color"    order="2"   label="ライトカラー"
*/

// @@ group="intensity_group" label="強度" order="2"
/* @@ intensity_group:
    uniform_id="intensities" order="1" label="r:環境 g:影 b:AO a:ベイクライト"
*/

// @@ group="envmap_group" label="環境テクスチャ" order="3"
/* @@ envmap_group:
    sampler_id="_r0"  order="1" label="反射マップ"
    sampler_id="_w0"  order="2" label="水面マップ"
    sampler_id="_d0"  order="3" label="影マップ"
    sampler_id="_c0"  order="4" label="カラーマップ"
    sampler_id="_gn0" order="5" label="法線マップ"
    sampler_id="_l0"  order="6" label="光マップ"
    sampler_id="_d1"  order="7" label="深度マップ"
*/

#else

// @@ group="envmap_group" label="環境テクスチャ" order="3" condition="false"
/* @@ envmap_group:
    sampler_id="_r0"  order="1" label="反射マップ"
    sampler_id="_w0"  order="2" label="水面マップ"
    sampler_id="_d0"  order="3" label="影マップ"
    sampler_id="_c0"  order="4" label="カラーマップ"
    sampler_id="_gn0" order="5" label="法線マップ"
    sampler_id="_l0"  order="6" label="光マップ"
    sampler_id="_d1"  order="7" label="深度マップ"
*/

#endif
