@echo off

set ToolRoot=%~1
set TargetDir=%~2
set Output=%~3
set ShdrCvtrOptions=%~4
set ExeBitSuffix=%~5
set Alignment=%~6
set Texture=%~7
set BuildTarget=%~8
set OUTPUT_DIR=%~dp3

call "%~dp0convert_env.bat" "%ToolRoot%" "%ExeBitSuffix%"

set TOWN_DIR=%ROOT%\town

set COMMAND_FILE=%OUTPUT_DIR%\command

if exist "%COMMAND_FILE%" del /q "%COMMAND_FILE%"

set yyyy=%date:~0,4%
set mm=%date:~5,2%
set dd=%date:~8,2%
set hh=%time:~0,2%
set mn=%time:~3,2%
set ss=%time:~6,2%

rem TEMP ϐ`ĂO
set TEMP_DIR=%TEMP%\Nintendo_G3dDemo_%BuildTarget%_%yyyy%%mm%%dd%%hh%%mn%%ss%
echo temporary folder is "%TEMP_DIR%"
if not exist "%TEMP_DIR%" (
    mkdir "%TEMP_DIR%"
    if errorlevel 1 goto ERROR
)

for %%f in ("%TargetDir%\*.fmdb") do (
    echo model path is "%%f"
    "%ASSIGNUTIL%" apply-parent-material "%%f" --shader-path "%ROOT%\shader" -o "%TEMP_DIR%" --parent-material-path "%~dp0ParentMaterials"
    if errorlevel 1 goto ERROR
)

"%VARIATIONGENERATOR%" "%TEMP_DIR%" --shader-definition "%ROOT%\shader\town.fsdb"  --skinning-count-option-id "skinning" --output "%OUTPUT_DIR%\town.fsva"
if errorlevel 1 goto ERROR

"%SHDRCVTR%" %SHDRCVTR_OPTIONS% %ShdrCvtrOptions% --force-variation --output="%OUTPUT_DIR%\town.bfsha" --glsl-extension="GL_ARB_texture_cube_map_array : enable" "%ROOT%\shader\town.fsdb" "%OUTPUT_DIR%\town.fsva"
if errorlevel 1 goto ERROR

echo --output="%Output%" >> "%COMMAND_FILE%"
for %%f in ("%TEMP_DIR%\*.fmdb") do echo "%%f" >> "%COMMAND_FILE%"
for %%f in ("%TargetDir%\*.fskb") do echo "%%f" >> "%COMMAND_FILE%"
for %%f in ("%TargetDir%\*.fmab") do echo "%%f" >> "%COMMAND_FILE%"
for %%f in ("%TargetDir%\*.fvbb") do echo "%%f" >> "%COMMAND_FILE%"
for %%f in ("%TargetDir%\*.fshb") do echo "%%f" >> "%COMMAND_FILE%"
echo --external-file="'%OUTPUT_DIR%\town.bfsha' --external-file-alignment=%Alignment%" >> "%COMMAND_FILE%"
if not "%Texture%" equ "" echo --external-file="'%Texture%' --external-file-alignment=%Alignment%" >> "%COMMAND_FILE%"

"%BINCVTR%" --args-file="%COMMAND_FILE%"
if errorlevel 1 goto ERROR

rd /s /q "%TEMP_DIR%"
del /q "%COMMAND_FILE%"
del /q "%OUTPUT_DIR%\town.fsva"
del /q "%OUTPUT_DIR%\town.bfsha"

exit /b 0

:ERROR
rd /s /q "%TEMP_DIR%"
del /q "%COMMAND_FILE%"
del /q "%OUTPUT_DIR%\town.fsva"
del /q "%OUTPUT_DIR%\town.bfsha"
exit /b 1
