﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/hid.h>
#include <nn/hid/hid_Npad.h>

namespace input {

/*!
    @brief      サポートしている Npad の数です。
*/
const int SupportedNpadCount = 8;

}

namespace input {

/*!
    @brief      入力モジュールを初期化します。
*/
void Initialize() NN_NOEXCEPT;

/*!
    @brief      Npad のボタン入力を取得します。

    @param[out] buttons ボタン入力。
    @param[in]  index   コントローラー番号。

    @pre
        buttons != nullptr
        0 <= index < SupportedNpadCount

    @details
                index に 0 を指定した場合、以下の処理が行われます。

                - フルキー操作可能な入力が存在しない場合、携帯機操作の入力取得を試みます。
                - Npad のボタン入力がない場合、DebugPad の入力取得を試みます。
*/
void GetButtons(nn::hid::NpadButtonSet* buttons, int index) NN_NOEXCEPT;

}
