﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "PadUtility.h"

#if defined(NN_BUILD_TARGET_PLATFORM_OS_WIN)
#ifndef WIN32_LEAN_AND_MEAN
#define WIN32_LEAN_AND_MEAN
#endif
#ifndef NOMINMAX
#define NOMINMAX
#endif
#include <nn/nn_Windows.h>
//adfsasdfasdf
#endif

//------------------------------------------------------------------------------
//  パッドユーティリティ
//------------------------------------------------------------------------------
nn::vi::NativeWindowHandle g_WndHandle = NULL;
nn::Bit32 g_PadButton;
nn::Bit32 g_PadLastButton;
nn::Bit32 g_PadTriggered;
nn::Bit32 g_PadReleased;
#if !defined(NN_BUILD_TARGET_PLATFORM_OS_WIN)
nn::hid::NpadIdType g_NpadIds[2];
#endif

void InitializePadUtility(nn::vi::Layer* pLayer)
{
    nn::hid::InitializeDebugPad();

#if defined(NN_BUILD_TARGET_PLATFORM_OS_WIN)
    nn::vi::GetNativeWindow(&g_WndHandle, pLayer);
#else
    nn::hid::InitializeNpad();

    nn::hid::SetSupportedNpadStyleSet(nn::hid::NpadStyleFullKey::Mask | nn::hid::NpadStyleJoyDual::Mask | nn::hid::NpadStyleHandheld::Mask);

    g_NpadIds[0] = nn::hid::NpadId::No1;
    g_NpadIds[1] = nn::hid::NpadId::Handheld;

    nn::hid::SetSupportedNpadIdType(g_NpadIds, 2);
#endif

    ResetPad();
}

void FinalizePadUtility()
{}

void ResetPad()
{
    g_PadButton = 0;
    g_PadLastButton = 0;
    g_PadTriggered = 0;
    g_PadReleased = 0;
}

void ReadPad()
{
    nn::Bit32 button = 0;

#if defined(NN_BUILD_TARGET_PLATFORM_OS_WIN)
    HWND hWnd = GetForegroundWindow();
    if (hWnd && hWnd == g_WndHandle)
    {
        static const nn::Bit16 HOLD_MASK = 0x8000;
        button |= (HOLD_MASK & GetKeyState(VK_LEFT)) ? BUTTON_LEFT : 0;
        button |= (HOLD_MASK & GetKeyState(VK_UP)) ? BUTTON_UP : 0;
        button |= (HOLD_MASK & GetKeyState(VK_RIGHT)) ? BUTTON_RIGHT : 0;
        button |= (HOLD_MASK & GetKeyState(VK_DOWN)) ? BUTTON_DOWN : 0;
        button |= (HOLD_MASK & GetKeyState('A')) ? BUTTON_A : 0;
        button |= (HOLD_MASK & GetKeyState('B')) ? BUTTON_B : 0;
        button |= (HOLD_MASK & GetKeyState('X')) ? BUTTON_X : 0;
        button |= (HOLD_MASK & GetKeyState('Y')) ? BUTTON_Y : 0;
    }
#else
    nn::hid::DebugPadState state;
    nn::hid::GetDebugPadState(&state);

    button |= state.buttons.Test<nn::hid::DebugPadButton::Left>() ? BUTTON_LEFT : 0;
    button |= state.buttons.Test<nn::hid::DebugPadButton::Up>() ? BUTTON_UP : 0;
    button |= state.buttons.Test<nn::hid::DebugPadButton::Right>() ? BUTTON_RIGHT : 0;
    button |= state.buttons.Test<nn::hid::DebugPadButton::Down>() ? BUTTON_DOWN : 0;
    button |= state.buttons.Test<nn::hid::DebugPadButton::A>() ? BUTTON_A : 0;
    button |= state.buttons.Test<nn::hid::DebugPadButton::B>() ? BUTTON_B : 0;
    button |= state.buttons.Test<nn::hid::DebugPadButton::X>() ? BUTTON_X : 0;
    button |= state.buttons.Test<nn::hid::DebugPadButton::Y>() ? BUTTON_Y : 0;

    nn::hid::NpadButtonSet npadState[2] = {};
    for (int idxNPad = 0; idxNPad < 2; idxNPad++)
    {
        nn::hid::NpadStyleSet style = nn::hid::GetNpadStyleSet(g_NpadIds[idxNPad]);

        // ジョイコン操作が有効な場合
        if (style.Test<nn::hid::NpadStyleJoyDual>() == true)
        {
            //最新のNpadのステートを取得
            nn::hid::NpadJoyDualState joyDualState;
            nn::hid::GetNpadState(&joyDualState, g_NpadIds[idxNPad]);
            npadState[idxNPad] = joyDualState.buttons;
        }

        // 携帯機コントローラー操作が有効な場合
        if (style.Test<nn::hid::NpadStyleHandheld>() == true)
        {
            //最新のNpadのステートを取得
            nn::hid::NpadHandheldState handheldState;
            nn::hid::GetNpadState(&handheldState, g_NpadIds[idxNPad]);
            npadState[idxNPad] = handheldState.buttons;
        }

        nn::hid::NpadButtonSet* pNpadState = &npadState[idxNPad];
        button |= pNpadState->Test<nn::hid::NpadJoyButton::Left>() ? BUTTON_LEFT : 0;
        button |= pNpadState->Test<nn::hid::NpadJoyButton::Up>() ? BUTTON_UP : 0;
        button |= pNpadState->Test<nn::hid::NpadJoyButton::Right>() ? BUTTON_RIGHT : 0;
        button |= pNpadState->Test<nn::hid::NpadJoyButton::Down>() ? BUTTON_DOWN : 0;
        button |= pNpadState->Test<nn::hid::NpadJoyButton::A>() ? BUTTON_A : 0;
        button |= pNpadState->Test<nn::hid::NpadJoyButton::B>() ? BUTTON_B : 0;
        button |= pNpadState->Test<nn::hid::NpadJoyButton::X>() ? BUTTON_X : 0;
        button |= pNpadState->Test<nn::hid::NpadJoyButton::Y>() ? BUTTON_Y : 0;
    }
#endif

    g_PadLastButton = g_PadButton;
    g_PadButton = button;

    nn::Bit32 changed = g_PadButton ^ g_PadLastButton;
    g_PadTriggered = changed & g_PadButton;
    g_PadReleased = changed & g_PadLastButton;
}

bool IsPadHold(nn::Bit32 mask)
{
    return 0 != (g_PadButton & mask);
}

bool IsPadTriggered(nn::Bit32 mask)
{
    return 0 != (g_PadTriggered & mask);
}

bool IsPadReleased(nn::Bit32 mask)
{
    return 0 != (g_PadReleased & mask);
}
