﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Macro.h>
#include <nn/font.h>
#include <nn/nn_Assert.h>
#include <nn/nn_Log.h>
#include <nn/fs.h>
#include <nn/font/font_PairFont.h>

#include "FontPairFont.h"

//------------------------------------------------------------------------------
//   定数定義
//------------------------------------------------------------------------------

// フォントバイナリファイル
static const char* const DemoColorFontFileName = "Contents:/ColorFont.bffnt";

//------------------------------------------------------------------------------
//   変数定義
//------------------------------------------------------------------------------

// ペアフォント関係
static nn::font::ResFont g_ColorResFont;
static nn::font::PairFont g_PairFont;

//------------------------------------------------------------------------------
//   初期化
//------------------------------------------------------------------------------
void InitializePairFont(nn::font::ResFont* pResFont)
{
    nn::gfx::Device* pDevice = g_GfxFramework.GetDevice();

    void* binary = NULL;
    {
        nn::Result result;
        nn::fs::FileHandle fileHandle;
        int64_t fileSize;

        result = nn::fs::OpenFile(&fileHandle, DemoColorFontFileName, nn::fs::OpenMode_Read);
        NN_ABORT_UNLESS_RESULT_SUCCESS(result);

        result = nn::fs::GetFileSize(&fileSize, fileHandle);
        NN_ABORT_UNLESS_RESULT_SUCCESS(result);

        binary = AllocateFromApplicationHeap(static_cast<size_t>(fileSize), nn::font::ResourceAlignment);
        size_t readSize;
        result = nn::fs::ReadFile(&readSize, fileHandle, 0, binary, static_cast<size_t>(fileSize));
        NN_ABORT_UNLESS_RESULT_SUCCESS(result);

        nn::fs::CloseFile(fileHandle);
    }
    NN_ASSERT_NOT_NULL(binary);

    //-----------------------------------------
    // フォントの初期化
    bool result = g_ColorResFont.SetResource(pDevice, binary);
    NN_ASSERT(result);
    g_ColorResFont.RegisterTextureViewToDescriptorPool(RegisterSlotForTexture, &g_GfxFramework);

    g_PairFont.SetFont(&g_ColorResFont, pResFont);
}

//------------------------------------------------------------------------------
//   解放
//------------------------------------------------------------------------------
void FinalizePairFont()
{
    nn::gfx::Device* pDevice = g_GfxFramework.GetDevice();

    g_ColorResFont.UnregisterTextureViewFromDescriptorPool(UnregisterSlotForTexture, &g_GfxFramework);

    void* pResourceColorFont = g_ColorResFont.RemoveResource(pDevice);
    DeallocateApplicationHeap(pResourceColorFont);
    g_ColorResFont.Finalize(pDevice);

    g_PairFont.Finalize(pDevice);
}

//------------------------------------------------------------------------------
//   フォントの設定
//------------------------------------------------------------------------------
void SetPairFont(nn::font::WideTextWriter* pTextWriter)
{
    pTextWriter->SetFont(&g_PairFont);
}
