﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <nns/gfx/gfx_GraphicsFramework.h>

// 文字コードの型を調整するマクロ
#define FONT_SAMPLE_LITERAL(string) reinterpret_cast<const uint16_t*>(NN_CHAR16LITERAL(string))

//------------------------------------------------------------------------------
// サンプルの動作モードです。
enum SampleMode
{
    SampleMode_Simple,       // 最も単純なサンプル
    SampleMode_PairFont,     // ペアフォントのサンプル
    SampleMode_WordWrapping, // ワードラップ処理のサンプル
    SampleMode_ScalableFont, // スケーラブルフォントのサンプル
    SampleMode_TagProcessor, // タグプロセッサのサンプル
    SampleMode_Exit,         // 終了
    SampleMode_CommandMenu,  // メニュー選択
};

extern SampleMode  g_NextSampleMode;

// グラフィックスフレームワーク
extern nns::gfx::GraphicsFramework g_GfxFramework;

// アプリケーションヒープからメモリを確保する
void* AllocateFromApplicationHeap(size_t size, size_t alignment, void* pUserData);
void* AllocateFromApplicationHeap(size_t size, size_t alignment);
void* AllocateFromApplicationHeap(size_t size);

// アプリケーションヒープから確保したメモリを開放する
void DeallocateApplicationHeap(void* ptr, void* pUserData);
void DeallocateApplicationHeap(void* ptr);

// スロットへの登録と解除
bool RegisterSlotForTexture(nn::gfx::DescriptorSlot* pDstSlot, const nn::gfx::TextureView& textureView, void* pUserData);
bool RegisterSlotForSampler(nn::gfx::DescriptorSlot* pDstSlot, const nn::gfx::Sampler& sampler, void* pUserData);
void UnregisterSlotForTexture(nn::gfx::DescriptorSlot* pDstSlot, const nn::gfx::TextureView& textureView, void* pUserData);
void UnregisterSlotForSampler(nn::gfx::DescriptorSlot* pDstSlot, const nn::gfx::Sampler& sampler, void* pUserData);

//------------------------------------------------------------------------------
//  構築・破壊
//------------------------------------------------------------------------------
template <typename TObject>
TObject* AllocAndConstruct()
{
    return new(AllocateFromApplicationHeap(sizeof(TObject), 4, NULL)) TObject();
}
template <typename TObject>
void DestructAndFree(TObject* ptr)
{
    ptr->TObject::~TObject();
    DeallocateApplicationHeap(ptr, NULL);
}

