﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>
#include <nn/nn_Assert.h>
#include <nn/nn_Log.h>
#include <nn/os.h>

#include "Demo1Time.h"

void InitializeTimeDemo() NN_NOEXCEPT
{
    // 時刻ライブラリの初期化
    NN_ABORT_UNLESS_RESULT_SUCCESS( nn::time::Initialize() );
}

void FinalizeTimeDemo() NN_NOEXCEPT
{
    // 時刻ライブラリの終了
    NN_ABORT_UNLESS_RESULT_SUCCESS( nn::time::Finalize() );
}

void GetCalendarTime(nn::time::CalendarTime* pCalendarTime,
                     nn::time::CalendarAdditionalInfo* pCalendarAdditionalInfo) NN_NOEXCEPT
{
    // POSIX 標準の経過秒数を取得し、人間が理解できる日時へ変換を行うサンプルです。
    {
        // 協定世界時 (UTC) の 西暦1970年1月1日午前0時0分0秒 からの経過秒数で現在時刻
        // を取得します。
        nn::time::PosixTime posixTime;
        NN_ABORT_UNLESS_RESULT_SUCCESS(
            nn::time::StandardUserSystemClock::GetCurrentTime(&posixTime)
        );

        // PosixTime を CalendarTime へ変換します。
        // 計算に利用されるタイムゾーンはデバイスに設定されたものを利用します。
        NN_ABORT_UNLESS_RESULT_SUCCESS(
            nn::time::ToCalendarTime(pCalendarTime, pCalendarAdditionalInfo, posixTime)
        );
    }
}
