﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os/os_Mutex.h>

class SaveDataAccessor
{
    NN_DISALLOW_COPY(SaveDataAccessor);
    NN_DISALLOW_MOVE(SaveDataAccessor);

public:
    SaveDataAccessor() NN_NOEXCEPT
        : m_Mutex(false)
        , m_HasAccount(false)
        , m_HasSpace(false)
    {}

    void EnableAccount(bool hasAccount) NN_NOEXCEPT
    {
        m_Mutex.Lock();
        m_HasAccount = hasAccount;
        m_Mutex.Unlock();
    }

    void EnableSpace(bool hasSpace) NN_NOEXCEPT
    {
        m_Mutex.Lock();
        m_HasSpace = hasSpace;
        m_Mutex.Unlock();
    }

    bool HasAccount() NN_NOEXCEPT
    {
        m_Mutex.Lock();
        bool  hasAccount = m_HasAccount;
        m_Mutex.Unlock();
        return hasAccount;
    }

    bool HasSpace() NN_NOEXCEPT
    {
        m_Mutex.Lock();
        bool  hasSpace = m_HasSpace;
        m_Mutex.Unlock();
        return hasSpace;
    }

private:
    nn::os::Mutex m_Mutex;

    bool m_HasAccount;
    bool m_HasSpace;
};
