﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <cstdlib>
#include <cstring>

#include <nn/fs.h>
#include <nn/nn_Abort.h>
#include <nn/nn_Assert.h>
#include <nn/nn_Log.h>

#include <nn/account/account_Api.h>
#include <nn/account/account_ApiForApplications.h>

#include "Demo1ScenePluginBase.h"

class SaveDataDemo : public ScenePluginBase
{
    NN_DISALLOW_COPY(SaveDataDemo);
    NN_DISALLOW_MOVE(SaveDataDemo);
public:
    SaveDataDemo() NN_NOEXCEPT {}
    virtual ~SaveDataDemo() NN_NOEXCEPT NN_OVERRIDE;

    virtual void Initialize() NN_NOEXCEPT NN_OVERRIDE;

    virtual void Start() NN_NOEXCEPT NN_OVERRIDE;

    virtual void Finalize() NN_NOEXCEPT NN_OVERRIDE;

    virtual void Wait() NN_NOEXCEPT NN_OVERRIDE;

private:
    static const size_t ThreadStackSize = 128 * 1024;

private:
    static void SaveDataThreadFunc(void* pArg) NN_NOEXCEPT;
    void SaveDataThreadFuncImpl() const NN_NOEXCEPT;

private:
    nn::os::ThreadType m_SaveDataThread;

    int m_UserCount;

    // SaveDataスレッド
    char*  m_pThreadStack;
};
