﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <cstdlib>
#include <cstring>

#include <nn/nn_Abort.h>
#include <nn/nn_Assert.h>
#include <nn/nn_Log.h>

#include <nn/hid/hid_Keyboard.h>
#include <nn/hid/hid_Npad.h>

#include "Demo1Color.h"
#include "Demo1NpadPluginBase.h"
#include "Demo1ScenePluginBase.h"

class KeyboardDemo : public ScenePluginBase
{
    NN_DISALLOW_COPY(KeyboardDemo);
    NN_DISALLOW_MOVE(KeyboardDemo);
public:
    KeyboardDemo() NN_NOEXCEPT {}
    virtual ~KeyboardDemo() NN_NOEXCEPT NN_OVERRIDE {}

    virtual void Initialize() NN_NOEXCEPT NN_OVERRIDE
    {
        m_IsLaunchKeyboard = true;
    }

    virtual void Start() NN_NOEXCEPT NN_OVERRIDE {}

    virtual void Finalize() NN_NOEXCEPT NN_OVERRIDE {}

    virtual void Draw() NN_NOEXCEPT NN_OVERRIDE;

    virtual void Wait() NN_NOEXCEPT NN_OVERRIDE {}

private:
    void GetKeyState() NN_NOEXCEPT;
    template<typename BUTTON>
    bool IsButtonPressed() const NN_NOEXCEPT;
    void AddStringButton(
        std::vector <std::string>* pAddDispString,
        const char* strButton) NN_NOEXCEPT;
    bool LaunchKeyboard() NN_NOEXCEPT;
    bool m_IsLaunchKeyboard;
    void WriteKeyboardState(
        nn::gfx::util::DebugFontTextWriter* pTextWriter,
        const float offsetX,
        const float offsetY) NN_NOEXCEPT;
    void WriteKeyboardTemplate(nn::gfx::util::DebugFontTextWriter* pTextWriter) const NN_NOEXCEPT;
    void MakeCommand(int64_t frame, const char* pName) NN_NOEXCEPT;

private:
    std::vector<std::string> m_OutString;
    NpadCommonState          m_CurrentNpadButtonState[NN_ARRAY_SIZE(NpadIds)];
    NpadCommonState          m_OldNpadButtonState[NN_ARRAY_SIZE(NpadIds)];
};
