﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/hid.h>

#include <nn/mem/mem_StandardAllocator.h>

#include "Demo1IrSensorDemo.h"
#include "Demo1ScenePluginBase.h"

namespace
{
const nn::hid::NpadIdType NpadIds1to2[] =
{
    ::nn::hid::NpadId::No1,
    ::nn::hid::NpadId::No2
};
}


class IrSensorViewDemo : public ScenePluginBase
{
    NN_DISALLOW_COPY(IrSensorViewDemo);
    NN_DISALLOW_MOVE(IrSensorViewDemo);
public:
    IrSensorViewDemo() NN_NOEXCEPT {}

    virtual ~IrSensorViewDemo() NN_NOEXCEPT NN_OVERRIDE {}

    virtual void Initialize() NN_NOEXCEPT NN_OVERRIDE;

    virtual void Finalize() NN_NOEXCEPT NN_OVERRIDE;

    virtual void Start() NN_NOEXCEPT NN_OVERRIDE;

    virtual void End() NN_NOEXCEPT NN_OVERRIDE;

    virtual void Draw() NN_NOEXCEPT NN_OVERRIDE;

    virtual void Wait() NN_NOEXCEPT NN_OVERRIDE;

private:
    void MakeCommand(int64_t frame, const char* pName) NN_NOEXCEPT;

private:
    IrSensorDemo m_DemoStates[NN_ARRAY_SIZE(NpadIds1to2)];
    void* m_pWorkMemoryBuffers[NN_ARRAY_SIZE(NpadIds1to2)];

    NN_PADDING4;
};
