﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/gfx.h>
#include <nn/hid.h>
#include <nn/irsensor.h>

#include <nn/gfx/util/gfx_DebugFontTextWriter.h>

#include <nns/gfx/gfx_PrimitiveRenderer.h>

#include "Demo1HandAnalysisUtil.h"
#include "Demo1NpadPluginBase.h"
#include "Demo1ScenePluginBase.h"

enum IrSensorMode {
    IrSensorMode_Moment = 0,
    IrSensorMode_Clustering = 1,
    IrSensorMode_ImageTransfer = 2,
    IrSensorMode_HandAnalysis = 3,
    IrSensorMode_Count = 4,
};

class Texture
{
public:
    Texture() NN_NOEXCEPT :
        m_Texture(),
        m_View(),
        m_Descriptor()
    {
    }

    nn::gfx::Texture& GetTexture() NN_NOEXCEPT { return m_Texture; }
    nn::gfx::TextureView& GetTextureView() NN_NOEXCEPT { return m_View; }
    nn::gfx::DescriptorSlot& GetDescriptorSlot() NN_NOEXCEPT { return m_Descriptor; }

private:
    nn::gfx::Texture m_Texture;
    nn::gfx::TextureView m_View;
    nn::gfx::DescriptorSlot m_Descriptor;
};

class Sampler
{
public:
    Sampler() NN_NOEXCEPT :
        m_Sampler(),
        m_Descriptor()
    {
    }

    nn::gfx::Sampler& GetSampler() NN_NOEXCEPT { return m_Sampler; }
    nn::gfx::DescriptorSlot& GetDescriptorSlot() NN_NOEXCEPT { return m_Descriptor; }

private:
    nn::gfx::Sampler m_Sampler;
    nn::gfx::DescriptorSlot m_Descriptor;
};

void CreateTexture(
    GraphicsSystem* pGraphicsSystem,
    int width,
    int height,
    nn::gfx::ImageFormat format,
    Texture* pTexture) NN_NOEXCEPT;

void CreateSampler(
    GraphicsSystem* pGraphicsSystem,
    Sampler* pSampler) NN_NOEXCEPT;

class IrSensorModeState;

class IrSensorDemo
{
    NN_DISALLOW_COPY(IrSensorDemo);
    NN_DISALLOW_MOVE(IrSensorDemo);
public:
    IrSensorDemo() NN_NOEXCEPT
        : m_CurrentProcessor()
        , m_NextProcessor()
        , m_IrCameraHandle()
        , m_MenuSelection()
    {
    }
    void Initialize(nn::hid::NpadIdType id, GraphicsSystem* pGraphicsSystem,
        void* pImageTransferWorkMemory) NN_NOEXCEPT;
    void Finalize() NN_NOEXCEPT;
    bool Run(int i, GraphicsSystem* pGraphicsSystem,
        nn::gfx::util::DebugFontTextWriter* pTextWriter) NN_NOEXCEPT;
    bool ProcessGamePad() NN_NOEXCEPT;

protected:
    int GetMenuIndex() const NN_NOEXCEPT;

private:
    void GetKeyState() NN_NOEXCEPT;
    template<typename BUTTON>
    bool IsButtonPressed() const NN_NOEXCEPT;

private:
    IrSensorMode                     m_CurrentProcessor;
    IrSensorMode                     m_NextProcessor;
    nn::hid::NpadIdType              m_NpadId;
    nn::irsensor::IrCameraHandle     m_IrCameraHandle;
    int                              m_MenuSelection;
    IrSensorModeState*               m_pModeStates[IrSensorMode_Count];
    NpadCommonState                  m_CurrentNpadButtonState;
    NpadCommonState                  m_OldNpadButtonState;
};
