﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "Demo1ScenePluginBase.h"

class FsDemo : public ScenePluginBase
{
    NN_DISALLOW_COPY(FsDemo);
    NN_DISALLOW_MOVE(FsDemo);
public:
    FsDemo() NN_NOEXCEPT;
    virtual ~FsDemo() NN_NOEXCEPT NN_OVERRIDE;

    virtual void Initialize() NN_NOEXCEPT NN_OVERRIDE;

    virtual void Finalize() NN_NOEXCEPT NN_OVERRIDE;

    virtual void Start() NN_NOEXCEPT NN_OVERRIDE;

    virtual void End() NN_NOEXCEPT NN_OVERRIDE;

    virtual void Wait() NN_NOEXCEPT NN_OVERRIDE;

private:
    static const size_t ThreadStackSize = 128 * 1024;

private:
    void FsThreadFuncImpl() const NN_NOEXCEPT;
    static void FsThreadFunc(void* pArg) NN_NOEXCEPT;

private:
    nn::fs::FileHandle m_RomFsFile;
    char* m_pFileBuffer;

    NN_PADDING4;

    nn::os::ThreadType m_FsThread;
    char* m_pMountRomCacheBuffer = NULL;

    char*  m_pThreadStack;
};
