﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "Demo1IrSensorModeState.h"

class ClusteringModeState : public IrSensorModeState
{
public:
    ClusteringModeState(
        IrSensorMode* pNextProcessor,
        int* pMenuSelection,
        nn::irsensor::IrCameraHandle irCameraHandle) NN_NOEXCEPT;
    virtual ~ClusteringModeState() NN_NOEXCEPT NN_OVERRIDE;

    virtual void Start() NN_NOEXCEPT NN_OVERRIDE;
    virtual void Update() NN_NOEXCEPT NN_OVERRIDE;
    virtual void Render(
        nns::gfx::PrimitiveRenderer::Renderer* pPrimitiveRenderer,
        nn::gfx::CommandBuffer* pCommandBuffer, int index) NN_NOEXCEPT NN_OVERRIDE;

private:
    nn::irsensor::ClusteringProcessorState  m_ClusteringProcessorState;
    nn::irsensor::ClusteringProcessorConfig m_ClusteringProcessorConfig;
    ReadWriteBase* m_pObjectPixelCountMin;
    ReadWriteBase* m_pObjectPixelCountMax;
    ReadWriteBase* m_pObjectIntensityMin;
    ReadWriteBase* m_pExternalLightFilter;
    ReadWriteBase* m_pObjectCount;
};
