﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Assert.h>

#include "AdtsHeaderReader.h"

AdtsHeaderReader::AdtsHeaderReader(void* pBitStream, size_t size)
    : m_BitStreamReader(pBitStream, size)
{
    auto syncword = m_BitStreamReader.Read(12);
    NN_ASSERT(syncword == 0xfff);
    m_BitStreamReader.Read(1);  // id
    m_BitStreamReader.Read(2);  // layer
    auto protection_absent = m_BitStreamReader.Read(1);
    m_BitStreamReader.Read(2);  // profile
    auto sampling_frequency_index = m_BitStreamReader.Read(4);
    switch (sampling_frequency_index)
    {
        case 0:
            m_SampleRate = 96000;
            break;
        case 1:
            m_SampleRate = 88200;
            break;
        case 2:
            m_SampleRate = 64000;
            break;
        case 3:
            m_SampleRate = 48000;
            break;
        case 4:
            m_SampleRate = 44100;
            break;
        case 5:
            m_SampleRate = 32000;
            break;
        case 6:
            m_SampleRate = 24000;
            break;
        case 7:
            m_SampleRate = 22050;
            break;
        case 8:
            m_SampleRate = 16000;
            break;
        case 9:
            m_SampleRate = 12000;
            break;
        case 10:
            m_SampleRate = 11025;
            break;
        case 11:
            m_SampleRate = 8000;
            break;
        case 12:
            m_SampleRate = 7350;
            break;
        default:
            NN_UNEXPECTED_DEFAULT;
    }
    m_BitStreamReader.Read(1);  // private_bit
    auto channel_configuration = m_BitStreamReader.Read(3);
    m_ChannelCount = channel_configuration;
    m_BitStreamReader.Read(1);  // original/copy
    m_BitStreamReader.Read(1);  // home
    m_BitStreamReader.Read(1);  // copyright_identification_bit
    m_BitStreamReader.Read(1);  // copyright_identification_start
    auto frame_length = m_BitStreamReader.Read(13);
    m_BitStreamReader.Read(11);  // adts_buffer_fullness
    auto number_of_raw_data_blocks_in_frame = m_BitStreamReader.Read(2);
    NN_ASSERT(number_of_raw_data_blocks_in_frame == 0);
    if (number_of_raw_data_blocks_in_frame == 0)
    {
        if (protection_absent == 0)
        {
            m_BitStreamReader.Read(16);  // crc_check
        }
    }
    m_FrameLength = frame_length - m_BitStreamReader.GetReadByteCount();
    m_HeaderSize = m_BitStreamReader.GetReadByteCount();
}

int AdtsHeaderReader::GetSampleRate() const
{
    return m_SampleRate;
}

int AdtsHeaderReader::GetChannelCount() const
{
    return m_ChannelCount;
}

size_t AdtsHeaderReader::GetFrameLength() const
{
    return m_FrameLength;
}

size_t AdtsHeaderReader::GetHeaderSize() const
{
    return m_HeaderSize;
}
