﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "bluetooth_Client.h"
#include <cstdlib>

class myBtClient : public bluetoothClient
{
};


static myBtClient client;

//-----------------------------------------------------------------------------
extern "C" void nnMain()
{
    NN_LOG("NBM_CLIENT NOW RUNNING \n");
    int64_t t1, t2;

    NN_LOG("[bluetooth] Starting up\n");
    client.startBluetooth();

    nn::os::SleepThread(nn::TimeSpan::FromSeconds(5));

    for (int i=1; i <= 0; i++)
    {
        NN_LOG("\n\nStarting LLR for 1 second\n");
        t1 = nn::os::GetSystemTick().ToTimeSpan().GetMilliSeconds();
        nn::bluetooth::ExtStartLlrMode();
        t2 = nn::os::GetSystemTick().ToTimeSpan().GetMilliSeconds();
        NN_LOG("\tStart LLR returned (%lld ms)\n", t2 - t1);
        nn::os::SleepThread(nn::TimeSpan::FromSeconds(1));

        NN_LOG("\n\nExiting LLR for 1 second\n");
        t1 = nn::os::GetSystemTick().ToTimeSpan().GetMilliSeconds();
        nn::bluetooth::ExtExitLlrMode();
        t2 = nn::os::GetSystemTick().ToTimeSpan().GetMilliSeconds();
        NN_LOG("\tExit LLR returned (%lld ms)\n", t2 - t1);
        nn::os::SleepThread(nn::TimeSpan::FromSeconds(1));
    }

    for (int i=1; i <= 2; i++)
    {
        NN_LOG("Set radio off for 1 second\n");
        t1 = nn::os::GetSystemTick().ToTimeSpan().GetMilliSeconds();
        nn::bluetooth::ExtSetRadio(false);
        t2 = nn::os::GetSystemTick().ToTimeSpan().GetMilliSeconds();
        NN_LOG("\tSet radio off returned (%lld ms)\n", t2 - t1);
        nn::os::SleepThread(nn::TimeSpan::FromSeconds(1));

        NN_LOG("Set radio on for 1 second\n");
        t1 = nn::os::GetSystemTick().ToTimeSpan().GetMilliSeconds();
        nn::bluetooth::ExtSetRadio(true);
        t2 = nn::os::GetSystemTick().ToTimeSpan().GetMilliSeconds();
        NN_LOG("\tSet radio on returned (%lld ms)\n", t2 - t1);
        nn::os::SleepThread(nn::TimeSpan::FromSeconds(1));
    }

    NN_LOG("[bluetooth] Shutting down \n");
    client.finishBluetooth();
}



