﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/os.h>
#include <nn/gfx/util/gfx_DebugFontTextWriter.h>
#include <nns/hid.h>
#include <nn/bluetooth.h>

#include "BleSimple_Scene.h"

class ScanScene : public SceneBase
{
public:
    /**
     * @brief       コンストラクタです
     */
    ScanScene(std::string title, uint16_t scanParameterId);

    /**
     * @brief       デストラクタです
     */
    virtual ~ScanScene() {};

    /**
     * @brief       BLE スキャンの結果を描画します
     */
    virtual void Draw(nn::gfx::util::DebugFontTextWriter* pTextWriter);

    /**
     * @brief       BLE スキャン結果を更新します
     */
    void UpdateScanResult();

    /**
     * @brief       コントローラの入力を処理します
     */
    virtual void ProcessControllerInput(nns::hid::ButtonSet buttons);

private:
    /**
     * @brief       BLE デバイスを対象とするBLE スキャンを開始します
     */
    bool StartBleScanGeneral();
    /**
     * @brief       BLE デバイスを対象とするBLE スキャンを停止します
     */
    bool StopBleScanGeneral();

    /**
     * @brief       スマートデバイスアプリケーションを対象とするBLE スキャンを開始します
     */
    bool StartBleScanSmartDevice();
    /**
     * @brief       スマートデバイスアプリケーションを対象とするBLE スキャンを停止します
     */
    bool StopBleScanSmartDevice();

    /**
     * @brief       BLE スキャンの結果をクリアします
     */
    void ClearScanResult();

    //!< BLE デバイスのBLE スキャン結果です
    nn::bluetooth::BleScanResult m_ScanResults[nn::bluetooth::BleScanResultCountMax];

    //!< BLE スキャンのパラメータ識別子です
    uint16_t m_ScanParameterId;

    //!< BLE デバイスを対象としたBLE スキャンが実行中であるかを示すフラグです
    bool m_IsScanningGeneral;

    //!< スマートデバイスアプリケーションを対象としたBLE スキャンが実行中であるかを示すフラグです
    bool m_IsScanningSmartDevice;

};  // class ScanScene
