﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @examplesource{Input.h,PageSampleBcatPractical}
 *
 * @brief
 *  入力取得プログラム
 */

#pragma once

#include <nn/nn_Common.h>
#include <nn/hid.h>
#include <nn/hid/hid_Npad.h>

namespace input {

/*!
    @brief      入力モジュールを初期化します。
*/
void Initialize() NN_NOEXCEPT;

/*!
    @brief      入力を更新します。

    @details
                本関数はボタン入力を取得し、前回取得したボタン入力の差分を計算します。@n
                計算した差分は、 @ref GetTriggerButtons や @ref GetReleaseButtons で取得できます。

                ボタン入力は以下の順に取得を試みます。

                # フルキー操作の Npad の入力
                # 携帯機操作の Npad の入力
                # DebugPad の入力（フルキー操作、および、携帯機操作の入力が空の場合）
*/
void Update() NN_NOEXCEPT;

/*!
    @brief      現在のフレームで新規に押されたボタン入力を取得します。

    @return     ボタン入力。

    @details
                定期的に @ref Update 関数を呼び出している必要があります。
*/
nn::hid::NpadButtonSet GetTriggerButtons() NN_NOEXCEPT;

/*!
    @brief      現在のフレームで離されたボタン入力を取得します。

    @return     ボタン入力。

    @details
                定期的に @ref Update 関数を呼び出している必要があります。
*/
nn::hid::NpadButtonSet GetReleaseButtons() NN_NOEXCEPT;

}
